/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.compat;

import com.rcx.materialis.MaterialisResources;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import slimeknights.tconstruct.common.registration.CastItemObject;

@JeiPlugin
public class MaterialisJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("materialis", "jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IIngredientManager manager = jeiRuntime.getIngredientManager();
        for (MaterialisResources.FluidWithBlockNBucket fluid : MaterialisResources.fluidList) {
            ITag<Item> ingot = MaterialisJEIPlugin.getTag(new ResourceLocation("forge", "ingots/" + fluid.name.replace("molten_", "")));
            if (ingot != null && !ingot.isEmpty()) continue;
            MaterialisJEIPlugin.removeFluid(manager, (Fluid)fluid.FLUID.get(), (Item)fluid.FLUID_BUCKET.get());
        }
        MaterialisJEIPlugin.optionalCast(manager, MaterialisResources.INLAY_CAST);
    }

    public static void removeFluid(IIngredientManager manager, Fluid fluid, Item bucket) {
        manager.removeIngredientsAtRuntime(VanillaTypes.FLUID, Collections.singleton(new FluidStack(fluid, 1000)));
        manager.removeIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singleton(new ItemStack((ItemLike)bucket)));
    }

    public static void optionalCast(IIngredientManager manager, CastItemObject cast) {
        ITag<Item> tag = MaterialisJEIPlugin.getTag(new ResourceLocation("forge", cast.getName().m_135815_() + "s"));
        if (tag == null || tag.isEmpty()) {
            manager.removeIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)cast.values().stream().map(ItemStack::new).collect(Collectors.toList()));
        }
    }

    private static ITag<Item> getTag(ResourceLocation name) {
        return MaterialisJEIPlugin.getTag((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)name));
    }

    private static ITag<Item> getTag(TagKey<Item> name) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(name);
    }
}

